﻿/*
PROPERTIES:
	mapData				read-write		(stores a reference for editing)
	mapFile				read-write
	chipset				read-write
	layer					read-write
	
EVENTS:
	onMapLoad
	onLayer
*/



// This adds display capabilities
_this = this;
display = {};
#include "functions/map.as"
map = makeMap( "map", _this, 1, 20, 15 );		// creates a 20x15 map at depth 1

// store component settings
display.initMapData = _this.mapData;
display.initMapFile = _this.mapFile;
display.initChipset = _this.chipset;
display.initLayer = _this.layer;
display.initShowBackground = _this.showBackground;

// OBJECTS
_this._mapData = {};
_this._layer = 0;
display._mapFile = {};
display._chipset = "";








// PROPERTIES
// // mapData
_this.getMapData = function( newValue ){
	return _this._mapData;
}// get()
_this.setMapData = function( newValue, doEvent ){
	if(newValue)
	{// if:  data specified
		_this._mapData = newValue;
		display._chipset = newValue.chipset;
		
		map.onLoad = function()
		{// onLoad()
			display._mapFile = null;		// map didn't come from a file
			// update layer opacity
			_this._layer = (_this._layer > _this._mapData.layers.length-1) ? _this._mapData.layers.length-1 : _this._layer;
			_this.layer = _this._layer;
			// update the chipset
			display._chipset = _this._mapData.chipset;
			// resize the transparent background
			display.updateBackground();
			// announce the change
			if(doEvent != false){
				_this.dispatchEvent({type:"onMapLoad"});
				_this.onMapLoad();
			}
			// remove this reaction  (map can be loaded in other ways)
			delete map.onLoad;
		}// onLoad()
		
		map.drawObj( newValue );
	}// if:  data specified
}// set()
_this.addProperty( "mapData", _this.getMapData, _this.setMapData );



// // mapFile
_this.getMapFile = function(){
	return display._mapFile;
}// get()
_this.setMapFile = function( newValue, doEvent ){
	if(newValue)
	{// if:  file specified
		display._mapFile = newValue;
		
		map.onLoad = function()
		{// onLoad()
			// intercept map data before it internally goes out of scope
			_this._mapData = map.loadData.map;
			display._chipset = map.loadData.map.chipset;
			// update layer opacity
			_this._layer = (_this._layer > _this._mapData.layers.length-1) ? _this._mapData.layers.length-1 : _this._layer;
			_this.layer = _this._layer;
			// update the chipset
			display._chipset = _this._mapData.chipset;
			// resize the transparent background
			display.updateBackground();
			// announce the change
			if(doEvent != false){
				_this.dispatchEvent({type:"onMapLoad"});
				_this.onMapLoad();
			}
			// remove this reaction  (map can be loaded in other ways)
			delete map.onLoad;
		}// onLoad()
		
		// load the specified file
		map.load( newValue );
	}// if:  file specified
}// set()
_this.addProperty( "mapFile", _this.getMapFile, _this.setMapFile );



// // chipset
_this.getChipset = function(){
	return display._chipset;
}// get()
_this.setChipset = function( newValue, doEvent ){
	if(newValue)
	{// if:  file specified
		display._chipset = newValue;
		_this._mapData.chipset = newValue;
		
		// redraw the map data using the new chipset
		_this.mapData = _this._mapData;
		// announce the change
		if(doEvent != false){
			_this.dispatchEvent({type:"onChipset"});
			_this.onChipset();
		}
	}// if:  file specified
}// set()
_this.addProperty( "chipset", _this.getChipset, _this.setChipset );



// // layer
_this.getLayer = function(){
	return _this._layer;
}// get()
_this.setLayer = function( newValue, doEvent ){
	if(newValue != _this._layer)
	{
		_this._layer = newValue;
		
		// announce the change
		if(doEvent != false){
			_this.dispatchEvent({type:"onLayer"});
			_this.onLayer();
		}
	}// if:  layer changed
	// change opacity of layers
	for(var L=0; L<_this._mapData.layers.length; L++)
	{
		var layerName = "layer"+L+"_mc";
		if(L <= newValue)
		{// if:  this layer is below or equal to the selected layer
			map[layerName]._alpha = 100;
		}// if:  this layer is below or equal to the selected layer
		else
		{// if:  this layer is above the selected layer
			map[layerName]._alpha = 33;
		}// if:  this layer is above the selected layer
	}// for:  each layer
}// set()
_this.addProperty( "layer", _this.getLayer, _this.setLayer );



// // showBackground
_this.getShowBackground = function( newValue ){
	return _this._showBackground;
}// get()
_this.setShowBackground = function( newValue, doEvent ){
	if(newValue != undefined)
	{// if:  data specified
		// store setting
		_this._showBackground = newValue;
		// update transparent BG
		var newAlpha = (newValue) ? 100 : 0;
		_this.transparent_mc._alpha = newAlpha;
		// announce the change
		if(doEvent != false){
			_this.dispatchEvent({type:"onShowBackground"});
			_this.onShowBackground();
		}
	}// if:  data specified
}// set()
_this.addProperty( "showBackground", _this.getShowBackground, _this.setShowBackground );



// ______________________________________________________________________________
// PROGRAM
display.updateBackground = function()
{
	if(_this.transparent_mc == undefined)
		_this.createEmptyMovieClip( "transparent_mc", 0 );
	var transparent_mc = _this.transparent_mc;
	var pixWidth = map.width*16;
	var pixHeight = map.height*16;
	var transparent_pic = flash.display.BitmapData.loadBitmap( "transparentPattern" );
	transparent_mc.clear();
	transparent_mc.beginBitmapFill( transparent_pic );
	transparent_mc.moveTo(0,0);										// top-left
	transparent_mc.lineTo( pixWidth, 0 );					// right
	transparent_mc.lineTo( pixWidth, pixHeight );	// down
	transparent_mc.lineTo( 0, pixHeight );				// left
	transparent_mc.lineTo(0,0);										// up
	transparent_mc.endFill();
	
	if(_this._showBackground){
		transparent_mc._alpha = 100;
	}else{
		transparent_mc._alpha = 0;
	}
}// updateBackground()



// ______________________________________________________________________________
// INITIALIZE

_this.layer = display.initLayer;

if(display.initMapData){
	_this.mapData = display.initMapData;			// load map data
}
else if(display.initMapFile){
	_this.mapFile = display.initMapFile;			// OR load map file
}
else if(display.initChipset){
	_this.chipset = display.initChipset;			// OR set chipset
}

_this.showBackground = (display.initShowBackground!=undefined) ? display.initShowBackground : true;		// show/hide checkered background


// ______________________________________________________________________________
// UNLOAD
display.unload = function()
{
	
	//
	_this.removeEventListener( "unload", display );
}// unload()
_this.addEventListener( "unload", display );